
"use strict";

require("syncLogDoorStats.js", "compileAllDoorStats");


// Load settings from modopts.ini
var optionsFromModopts = load({}, "modopts.js", "dd_web_door_stats");
if (!optionsFromModopts)
	optionsFromModopts = {};
var settings = {
	doorsToSkip: [],
	usersToSkip: []
};
if (optionsFromModopts.hasOwnProperty("doorsToSkip") && typeof(optionsFromModopts.doorsToSkip) === "string")
	settings.doorsToSkip = optionsFromModopts.doorsToSkip.split(",");
if (optionsFromModopts.hasOwnProperty("usersToSkip") && typeof(optionsFromModopts.usersToSkip) === "string")
	settings.usersToSkip = optionsFromModopts.usersToSkip.split(",");

// Compile the door stats and update the cached JSON file
var gDoorStats = compileAllDoorStats(settings.doorsToSkip, settings.usersToSkip, false, false/*true*/);
// Save the stats to the JSON file
var statsJsonFile = new File(gStatsJsonFilename);
if (statsJsonFile.open("w"))
{
	statsJsonFile.write(JSON.stringify(gDoorStats));
	statsJsonFile.close();
	log(LOG_INFO, "Successfully wrote door stats to " + gStatsJsonFilename);
}
else
	log(LOG_ERR, "Failed to write door stats to " + gStatsJsonFilename);
